/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsClientData;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class IOSurveyResultsBean
extends PanelBean
implements TaskNotifyCompleteListener {
    public static final int PARTID_COLUMN = 0;
    public static final int ACT_COLUMN = 1;
    public static final int RES_COLUMN = 2;
    public static final int MACHINE_COLUMN = 3;
    public static final int MTMS_COLUMN = 4;
    public static final int ILVL_COLUMN = 5;
    public static final int RLVL_COLUMN = 6;
    public static final int IMPACT_COLUMN = 7;
    public static final int SUGGEST_COLUMN = 8;
    public static final int NUM_COLUMNS = 9;
    public static final String RESOURCE_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "RESOURCE_VALUE", "Logical Device");
    public static final String MTMS_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "MTMS_VALUE", "MTMS");
    public static final String MACHINE_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "MACHINE_VALUE", "Device");
    public static final String SUGGESTED_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "SUGGESTED_VALUE", "Suggested");
    public static final String COLUMN_RESOURCE = "LogicalDevice";
    public static final String COLUMN_MTMS = "MTMSNumber";
    public static final String COLUMN_MACHINE = "DeviceName";
    public static final String COLUMN_SUGGESTED = "SuggestedAction";
    public static final String CHECKED = "TRUE";
    public static final String UNCHECKED = "FALSE";
    public static final String SORTABLE = "TRUE";
    public static final String UNSORTABLE = "FALSE";
    public static final String ENABLED = "YES";
    public static final String DISABLED = "NO";
    public static final String SERVICE_LEVEL = "ServiceLevel";
    public static final String SORT_BOX = "SortBy";
    public static final String RESOURCE_TABLE = "SurveyResponseTable";
    public static final String AUTO = "Auto";
    public static final String NOT_FOUND = SurveyFileResult.notFound;
    private static final String HTMLUlineBegin = "<html> <B>";
    private static final String HTMLUlineEnd = "</B> </html>";
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    protected RepositoryItem _repos;
    protected List surveyResults;
    protected SurveyFileResult[] inSurveyFile = null;
    protected ResourceList srv_res;
    protected IOSurveyResultsClientData surveyData;
    protected boolean readOnly = false;
    protected boolean backLevel = false;
    protected String currentServiceLevel;
    protected String rlvl;
    public int numObjects;
    private ArrayList osRows = new ArrayList(100);
    private String m_sReposLocation;
    LocalizableText userResponse;
    boolean currentSystemLevel = true;

    public IOSurveyResultsBean(IOSurveyResultsClientData iOSurveyResultsClientData) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean()");
        }
        if (iOSurveyResultsClientData == null && 1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "input IOSurveyResultsClientData is null!");
        }
        this.setSurveyData(iOSurveyResultsClientData);
        this.setResourceList(iOSurveyResultsClientData.getResources());
        this.setSurveyResults(iOSurveyResultsClientData.getSurveyResults());
        this.setReadOnly(iOSurveyResultsClientData.getReadOnly());
        this.setBackLevel(iOSurveyResultsClientData.getBackLevel());
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean()");
        }
    }

    public void prepare() {
        this.setRepos(this.getSurveyData().getReposLevel());
        this.setReposLocation(this.getSurveyData().getReposLevel().toString());
        this.populateSortOptions();
        UserTaskManager userTaskManager = this.getUserTaskManager();
        userTaskManager.addTaskNotifyCompleteListener((TaskNotifyCompleteListener)this, SORT_BOX);
        try {
            this.populateServiceLevel(this.getSurveyData().getServiceLevel());
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            // empty catch block
        }
        this.populateResults(true);
    }

    public int getResourceTableSize() {
        return this.numObjects;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setBackLevel(boolean bl) {
        this.backLevel = bl;
    }

    public boolean getBackLevel() {
        return this.backLevel;
    }

    public void setSurveyResults(List list) {
        this.surveyResults = list;
    }

    public List getSurveyResults() {
        return this.surveyResults;
    }

    public void setResourceList(ResourceList resourceList) {
        this.srv_res = resourceList;
    }

    public ResourceList getResourceList() {
        return this.srv_res;
    }

    public void setSurveyData(IOSurveyResultsClientData iOSurveyResultsClientData) {
        this.surveyData = iOSurveyResultsClientData;
    }

    public IOSurveyResultsClientData getSurveyData() {
        return this.surveyData;
    }

    public void setRepos(RepositoryItem repositoryItem) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> setRepos()");
        }
        this._repos = repositoryItem;
        this.getUserTaskManager().setValue("ReposLocation", this._repos.toString());
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- setRepos()");
        }
    }

    public RepositoryItem getReposLevel() {
        return this._repos;
    }

    public RepositoryItem getRepos() {
        return this._repos;
    }

    public String getReposLocation() {
        return this.m_sReposLocation;
    }

    public void setReposLocation(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> setReposLocation() " + string);
        }
        this.m_sReposLocation = string;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- setReposLocation() ");
        }
    }

    public void setUseCurrentLevel(boolean bl) {
        this.currentSystemLevel = bl;
    }

    public boolean getUseCurrentLevel() {
        return this.currentSystemLevel;
    }

    public void populateSortOptions() {
        UserTaskManager userTaskManager = this.getUserTaskManager();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean().populateSortOptions");
        }
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(RESOURCE_VALUE, RESOURCE_VALUE));
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(MTMS_VALUE, MTMS_VALUE));
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(MACHINE_VALUE, MACHINE_VALUE));
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(SUGGESTED_VALUE, SUGGESTED_VALUE));
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().populateSortOptions");
        }
    }

    public void populateServiceLevel(String string) throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean().populateServiceLevels");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().PopulateServiceLevels");
        }
    }

    public void populateResults(boolean bl) {
        block29: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean().populateResults");
            }
            boolean bl2 = false;
            UserTaskManager userTaskManager = this.getUserTaskManager();
            ResourceList resourceList = this.getResourceList();
            try {
                this.removeAllRows();
                this.surveyResults = this.getSurveyResults();
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Surveys have been completed");
                }
                if (this.surveyResults == null) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "No SurveyResults available...");
                        Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().PopulateResults");
                    }
                    return;
                }
                Iterator iterator = this.surveyResults.iterator();
                if (iterator == null) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "No SurveyResults available...");
                        Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().PopulateResults");
                    }
                    return;
                }
                int n = 0;
                int n2 = 0;
                String string = "";
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "Starting loop of resources");
                }
                boolean bl3 = true;
                boolean bl4 = false;
                while (iterator.hasNext()) {
                    Object object;
                    ResourceItem resourceItem = (ResourceItem)iterator.next();
                    bl3 = true;
                    if (resourceItem.getResourceType() == 3) {
                        if (resourceItem.getSRVPAR().equals("Y")) {
                            bl3 = true;
                            bl4 = true;
                        } else if (!bl4) {
                            bl3 = true;
                            bl4 = true;
                        } else {
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[9];
                    String[] stringArray = new String[5];
                    stringArray[0] = resourceItem.getPARID();
                    stringArray[1] = resourceItem.getDEVNM();
                    if (resourceItem.getResourceType() == 1) {
                        itemDescriptorArray[0] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 0, resourceItem.getName());
                        itemDescriptorArray[2] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 2, " ");
                        object = new Integer(n);
                        this.osRows.add(object);
                        if (1 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKD, "osRows[" + n2 + "]=" + this.osRows.get(n2));
                        }
                        ++n2;
                    } else {
                        if (resourceItem.getResourceType() == 6) {
                            itemDescriptorArray[0] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 0, "BPA");
                            object = new Integer(n);
                            this.osRows.add(object);
                            ++n2;
                        } else {
                            itemDescriptorArray[0] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 0, " ");
                        }
                        itemDescriptorArray[2] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 2, resourceItem.getDEVNM());
                    }
                    itemDescriptorArray[3] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 3, resourceItem.getMachine());
                    itemDescriptorArray[4] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 4, resourceItem.getMTMS());
                    string = resourceItem.getSuggestString();
                    object = "FALSE";
                    stringArray[2] = "FALSE";
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "userModified is " + resourceList.userModified);
                    }
                    if (resourceList.userModified) {
                        if (resourceItem.getChecked()) {
                            object = "TRUE";
                            stringArray[2] = "TRUE";
                        }
                    } else {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "ISMAN is " + resourceItem.getISMAN());
                        }
                        if (resourceItem.getISMAN().equals("Y") && resourceItem.getSuggest() == 1 && resourceItem.getImpact().equals(ResourceItem.impactNone)) {
                            object = "TRUE";
                            stringArray[2] = "TRUE";
                        }
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "row[" + n + "] checked set to " + (String)object);
                    }
                    String string2 = "SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 1;
                    itemDescriptorArray[1] = new ItemDescriptor(string2, (String)object);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "row[" + n + "] checked=" + (String)object);
                    }
                    stringArray[3] = "TRUE";
                    itemDescriptorArray[4].setUserObject((Object)stringArray);
                    itemDescriptorArray[5] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 5, resourceItem.getCurrentLevel());
                    itemDescriptorArray[6] = bl ? new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 6, resourceItem.getAvailableLevelAtThisRelease()) : new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 6, resourceItem.getPreviousLevel());
                    itemDescriptorArray[7] = resourceItem.getResourceType() == 1 ? new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 7, " ") : new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 7, resourceItem.getImpact());
                    itemDescriptorArray[8] = resourceItem.getResourceType() == 1 ? new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 8, " ") : new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 8, string);
                    userTaskManager = this.getUserTaskManager();
                    userTaskManager.addRow(RESOURCE_TABLE, n, itemDescriptorArray);
                    resourceItem.setTableRow(n);
                    ++n;
                }
                this.numObjects = n;
            }
            catch (Exception exception) {
                if (2 > Trace.LEVEL) break block29;
                Trace.trace(TRACE_MASKF, "Exception " + exception + " populating SurveyResult table.");
            }
        }
        this.sortAlpha(RESOURCE_TABLE, 2, this.osRows);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "Number of items in result table is " + this.numObjects);
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().PopulateResults");
        }
    }

    protected void enableRows(UserTaskManager userTaskManager) {
        String[] stringArray = new String[5];
        for (int i = 0; i < this.numObjects; ++i) {
            ItemDescriptor[] itemDescriptorArray = userTaskManager.getRow(RESOURCE_TABLE, i);
            stringArray = (String[])itemDescriptorArray[4].getUserObject();
            String string = itemDescriptorArray[1].getName();
            String string2 = itemDescriptorArray[4].getTitle();
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = itemDescriptorArray[5].getTitle();
            ResourceItem resourceItem = this.findResourceItem(string2, string3, string4);
            if (this.checkEnableRow(resourceItem, stringArray)) {
                stringArray[4] = ENABLED;
                userTaskManager.setEnabled(string, true);
                if (2 > Trace.LEVEL) continue;
                Trace.trace(TRACE_MASKF, "row[" + i + "] enabled=" + ENABLED);
                continue;
            }
            stringArray[4] = DISABLED;
            userTaskManager.setEnabled(string, false);
            if (2 > Trace.LEVEL) continue;
            Trace.trace(TRACE_MASKF, "row[" + i + "] enabled=" + DISABLED);
        }
    }

    protected void removeAllRows() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean().removeAllRows");
        }
        UserTaskManager userTaskManager = this.getUserTaskManager();
        try {
            while (true) {
                userTaskManager.removeRow(RESOURCE_TABLE, 0);
            }
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().removeAllRows");
            }
            return;
        }
    }

    protected boolean checkEnableRow(ResourceItem resourceItem, String[] stringArray) {
        if (resourceItem.getResourceType() == 1 || !resourceItem.getISMAN().equals("Y")) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Either OS or not managed");
            }
            stringArray[3] = "FALSE";
            return false;
        }
        if (resourceItem.getResourceType() == 3 && !resourceItem.getSRVPAR().equals("Y")) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "System & not Service Partition");
            }
            return false;
        }
        if (resourceItem.getResourceType() == 6) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "BPA, can't sort");
            }
            stringArray[3] = "FALSE";
        }
        if (this.getBackLevel()) {
            return true;
        }
        if (resourceItem.getSuggest() != 1) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Not Upgrade");
            }
            return false;
        }
        return !this.getReadOnly();
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean().taskCompleted");
        }
        String string = taskNotifyCompleteEvent.getElementName();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "Element Name: " + string);
        }
        if (string.equals(SERVICE_LEVEL)) {
            this.currentServiceLevel = taskNotifyCompleteEvent.getValue();
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Current Service Level: " + this.currentServiceLevel);
            }
            this.populateResults(true);
        } else {
            String string2 = taskNotifyCompleteEvent.getValue();
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Value selected: " + string2);
            }
            if (string2.equals(RESOURCE_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 2, this.osRows);
            } else if (string2.equals(MTMS_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 4, this.osRows);
            } else if (string2.equals(MACHINE_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 3, this.osRows);
            } else if (string2.equals(SUGGESTED_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 8, this.osRows);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().taskCompleted");
        }
    }

    public void load() {
    }

    public void save() {
    }

    private void sortAlpha(String string, int n, ArrayList arrayList) {
        ItemDescriptor[] itemDescriptorArray;
        ItemDescriptor[] itemDescriptorArray2;
        int n2;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean.sortAlpha()");
        }
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        ArrayList<ItemDescriptor[]> arrayList2 = new ArrayList<ItemDescriptor[]>(this.numObjects);
        boolean bl = false;
        ArrayList arrayList3 = new ArrayList();
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = arrayList.size();
        do {
            n3 = (Integer)arrayList.get(n5);
            n4 = n5 + 1 < n7 ? (Integer)arrayList.get(n5 + 1) - 1 : this.numObjects - 1;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "osRows[" + n5 + "]=" + arrayList.get(n5) + "  endRow=" + n4);
            }
            n6 = n4 - n3 + 1;
            arrayList2.clear();
            for (n2 = n3; n2 <= n4; ++n2) {
                itemDescriptorArray2 = this.getUserTaskManager().getRow(string, n2);
                arrayList2.add(itemDescriptorArray2);
            }
            for (n2 = 1; n2 < n6 - 1; ++n2) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "IOSurveyResultsBean.sortAlpha() Sorting at array element " + n2);
                }
                itemDescriptorArray = itemDescriptorArray2 = (ItemDescriptor[])arrayList2.get(n2);
                String string2 = itemDescriptorArray2[n].getTitle();
                int n8 = n2;
                for (int i = n2 + 1; i <= n6 - 1; ++i) {
                    ItemDescriptor[] itemDescriptorArray3 = (ItemDescriptor[])arrayList2.get(i);
                    String string3 = itemDescriptorArray3[n].getTitle();
                    if (collator.compare(string2, string3) <= 0) continue;
                    n8 = i;
                    string2 = string3;
                    itemDescriptorArray = itemDescriptorArray3;
                }
                if (n8 == n2) continue;
                arrayList2.set(n2, itemDescriptorArray);
                arrayList2.set(n8, itemDescriptorArray2);
                bl = true;
            }
            for (n2 = n3; n2 <= n4; ++n2) {
                arrayList3.add(n2, arrayList2.get(n2 - n3));
            }
        } while (++n5 < n7);
        for (n2 = 0; n2 < this.numObjects; ++n2) {
            this.getUserTaskManager().removeRow(string, 0);
        }
        itemDescriptorArray = this.getUserTaskManager();
        for (int i = 0; i < this.numObjects; ++i) {
            itemDescriptorArray2 = (ItemDescriptor[])arrayList3.get(i);
            String[] stringArray = (String[])itemDescriptorArray2[4].getUserObject();
            stringArray[2] = itemDescriptorArray2[1].getTitle();
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "hiddenData 0:" + stringArray[0] + " 1:" + stringArray[1] + " 2:" + stringArray[2] + " 3:" + stringArray[3] + " 4:" + stringArray[4]);
            }
            String string4 = "SurveyResponseTable." + System.currentTimeMillis() + "." + i + "." + 1;
            itemDescriptorArray2[1] = new ItemDescriptor(string4, stringArray[2]);
            itemDescriptorArray.addRow(string, i, itemDescriptorArray2);
        }
        if (!bl && 3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "IOSurveyResultsBean.sortAlpha() table " + string + "  already sorted");
        }
        this.enableRows((UserTaskManager)itemDescriptorArray);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean.sortAlpha()");
        }
    }

    public void verifyChanges() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsBean().verifyChanges");
        }
        UserTaskManager userTaskManager = this.getUserTaskManager();
        String string = "";
        for (int i = 0; i < this.numObjects; ++i) {
            ItemDescriptor[] itemDescriptorArray = userTaskManager.getRow(RESOURCE_TABLE, i);
            String string2 = itemDescriptorArray[2].getTitle();
            String string3 = itemDescriptorArray[4].getTitle();
            String string4 = itemDescriptorArray[3].getTitle();
            String string5 = string2 + "/" + string3 + "/" + string4;
            if (!itemDescriptorArray[1].getTitle().equals("TRUE")) continue;
            string = string + string5 + "\n";
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().verifyChanges");
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "panelAction( " + taskActionEvent + " )");
            Trace.trace(TRACE_MASKT, "panelAction( " + taskActionEvent.getElementName() + " )");
        }
        UserTaskManager userTaskManager = this.getUserTaskManager();
        String string = taskActionEvent.getElementName();
        if (string.equals("Cancel")) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Cancel pushed");
            }
            this.dispose();
        } else {
            Object object;
            ResourceItem resourceItem;
            String string2;
            String string3;
            String string4;
            String string5;
            String[] stringArray;
            ItemDescriptor[] itemDescriptorArray;
            PanelTaskletRequest panelTaskletRequest;
            Object object2;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "panelAction( " + taskActionEvent + " )");
            }
            if (string.equals("OK")) {
                object2 = this.getSurveyResults();
                int n = this.numObjects;
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Number of rows in table is: " + n);
                }
                panelTaskletRequest = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    itemDescriptorArray = userTaskManager.getRow(RESOURCE_TABLE, i);
                    if (itemDescriptorArray == null) {
                        if (3 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKD, "Error NonExisting row in resource Table");
                            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean.actionPerformed() ");
                        }
                        return;
                    }
                    stringArray = (String[])itemDescriptorArray[4].getUserObject();
                    string5 = itemDescriptorArray[4].getTitle();
                    string4 = stringArray[0];
                    string3 = stringArray[1];
                    string2 = itemDescriptorArray[5].getTitle();
                    resourceItem = this.findResourceItem(string5, string4, string3);
                    if (resourceItem == null) {
                        if (3 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "INTERNAL ERROR: did not find resource for " + string5);
                        }
                        return;
                    }
                    if (itemDescriptorArray[1].getTitle().equals("TRUE")) {
                        if (3 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKD, "IOSurveyResultsBean.panelAction() Update " + string5 + ":" + string4 + ":" + string3 + " to level " + itemDescriptorArray[6].getTitle());
                        }
                        resourceItem.setChecked(true);
                    } else {
                        resourceItem.setChecked(false);
                    }
                    if (3 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, " [IOSurveyResultsBean.panelAction()] set checked status for " + string5 + ":" + string4 + ":" + string3 + " to " + resourceItem.getChecked());
                    }
                    resourceItem.setReturnCode(0);
                    resourceItem.setReturnMessage("");
                    this.getSurveyData().setUseCurrentLevel(true);
                    resourceItem.setTableRow(i);
                    panelTaskletRequest.add(i, resourceItem);
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Total Rows Examined: " + panelTaskletRequest.size());
                }
                object = new PanelTaskletRequest();
                object.setData("event", (Object)taskActionEvent);
                object.setData("selectedResources", (Object)panelTaskletRequest);
                this.postTaskletRequest((PanelTaskletRequest)object);
            }
            if (string.equals("ViewInfo")) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "IOSurveyResultsBean ViewInfo selected... ");
                }
                object2 = this.getSurveyData().getReposLevel();
                int[] nArray = userTaskManager.getSelectedRows(RESOURCE_TABLE);
                panelTaskletRequest = new PanelTaskletRequest();
                if (nArray.length != 1) {
                    panelTaskletRequest.setData("event", (Object)taskActionEvent);
                    panelTaskletRequest.setData("selectedResources", null);
                } else {
                    itemDescriptorArray = userTaskManager.getRow(RESOURCE_TABLE, nArray[0]);
                    object = itemDescriptorArray[6].getTitle();
                    string4 = itemDescriptorArray[3].getTitle();
                    stringArray = (String[])itemDescriptorArray[4].getUserObject();
                    string5 = itemDescriptorArray[4].getTitle();
                    string3 = stringArray[0];
                    string2 = stringArray[1];
                    stringArray[2] = itemDescriptorArray[1].getTitle();
                    if (3 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "Row selected:" + nArray[0] + " " + string5 + " " + string3 + " " + string2);
                    }
                    resourceItem = this.findResourceItem(string5, string3, string2);
                    panelTaskletRequest.setData("event", (Object)taskActionEvent);
                    panelTaskletRequest.setData("selectedResources", (Object)resourceItem);
                }
                this.postTaskletRequest(panelTaskletRequest);
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "<- IOSurveyResultsBean().panelAction");
                }
            }
        }
    }

    public ResourceItem findResourceItem(String string, String string2, String string3) {
        HashMap hashMap;
        ResourceList resourceList;
        ResourceItem resourceItem;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> findResourceItem for " + string + ":" + string2 + ":" + string3);
        }
        if ((resourceItem = (resourceList = this.getResourceList()).getResource(string, string2, string3, hashMap = resourceList.getResourceMap())) == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- findResourceItem for " + string + ":" + string2 + ":" + string3 + " NOT found");
            }
            return null;
        }
        return resourceItem;
    }
}

